# Notes from https://www.crummy.com/software/BeautifulSoup/bs4/doc/
# Notes from https://codeburst.io/web-scraping-101-with-python-beautiful-soup-bb617be1f486

from bs4 import BeautifulSoup
import requests
# Here, we're just importing both Beautiful Soup and the Requests library
page_link = 'https://data.cityofnewyork.us/Health/DOHMH-New-York-City-Restaurant-Inspection-Results/rs6k-p7g6'
# this is the url that we've already determined is safe and legal to scrape from.
page_response = requests.get(page_link, timeout=500)
# here, we fetch the content from the url, using the requests library
soup = BeautifulSoup(page_response.content, "html.parser")
#we use the html parser to parse the url content and store it in a variable.

# print(soup.prettify())

print(soup.title)

# print(soup.title.name)

# print(soup.title.string)

# print(soup.title.parent.name)

get_rows = soup.find_all('div', class_="table-row")

print(len(get_rows))



Request URL: https://data.cityofnewyork.us/api/id/43nn-pn8j.json?$select=`camis`,`dba`,`boro`,`building`,`street`,`zipcode`,`phone`,`cuisine_description`,`inspection_date`,`action`,`violation_code`,`violation_description`,`critical_flag`,`score`,`grade`,`grade_date`,`record_date`,`inspection_type`,`latitude`,`longitude`,`community_board`,`council_district`,`census_tract`,`bin`,`bbl`,`nta`,`location_point`&$order=`:id`+ASC&$limit=14&$offset=14







